# IBM_PROLOG_BEGIN_TAG 
# This is an automatically generated prolog. 
#  
#  
#  
# Licensed Materials - Property of IBM 
#  
# (C) COPYRIGHT International Business Machines Corp. 2003,2004 
# All Rights Reserved 
#  
# US Government Users Restricted Rights - Use, duplication or 
# disclosure restricted by GSA ADP Schedule Contract with IBM Corp. 
#  
# IBM_PROLOG_END_TAG 
#
#
# @(#)71   1.33   src/csm/install/pkgdefs/Linux-RedHat7.2.pm.perl, setup, csm_rameh, rameh0431a 6/28/04 16:34:17

#--------------------------------------------------------------------------------

=head3  Linux-RedHat7.2.pm.perl

        Package Definition File:   RedHat 7.2

        Notes:

        The following global variables must be initalized before including
        this file:

                $::mgmt_type    = [MgmtServer | MgdNode ]
                $::csm_version  = [1.3.0 | 1.3.1 | 1.3.2 | ... ]


        exceptions:
        This file has been rewritten for csm 1.3.4 to rely on default values
        with support for release-specific exceptions.  This makes it much
        simpler to maintain the package defs across releases.

	The approach uses $::csm_version to set default values for both server and
	node defines.  It allows for execptions to these default values by defining
	specific csm versions assignments which overwrite the defaults when
	$::csm_version is equal to the execption's version number.

	ORDER IS IMPORTANT:
	As noted in the code, any excptions must follow the default assignments,
	otherwise the execption assignment will be overwriten by the default.


	OTHER DOCUMENTATION - see comments in pkgdefs/Linux.pm.perl


=cut

#--------------------------------------------------------------------------------

# houskeeping

package RedHat72;

do "/opt/csm/install/pkgdefs/Linux.pm";

NodeUtils->messageFromCat(
                          'csmInstall.cat',
                          $::MSGMAPPATH,
                          'csminstall',
                          'V',
                          'IMsgLoading',
                          "/opt/csm/install/pkgdefs/Linux-RedHat7.2.pm"
                          );

# fewer typos
my $_server_ = 'MgmtServer';
my $_node_   = 'MgdNode';

#--------------------------------------------------------------------------------

=head3	DISTRO Defintions

	Notes :

=cut

#--------------------------------------------------------------------------------
{

    $::pkgdefs{DISTRO_NAME}     = "Red Hat Linux 7.2";
    $::pkgdefs{DISTRO_DISKLIST} = "1 2";
    $::pkgdefs{DISTRO_RPMDIR}   = "RedHat/RPMS";

}

#--------------------------------------------------------------------------------

=head3  distro_disks - Distribution Disk Defines

        Distribution Disk descriptions used to prompt for the CD-ROMs
        during installation.

        One stanza per CDROM:

                num                     = the number on the CD-ROM's label
                name                    = the text string describing the CD-ROM
                diskid_filename         = the filename to search to identify the disk
                                          - supportsw shell wildcards.
                diskid_searchstring     = the string to search for in diskid_filename
                                          - supports perl regular expressions


=cut

#--------------------------------------------------------------------------------
{
    my $dd_ref;

    $dd_ref = [
        {
         num  => '1',
         name => $::pkgdefs{DISTRO_NAME},

         diskid_searchargs => {
                               file => '.disc1-i386',
                               key  => '1000086355.369516',
         },
         diskid_searchprog => \&linux_diskid_match_prog,
         diskid_target     => 'RedHat7.2-i386',
        },
        {
         num  => '2',
         name => $::pkgdefs{DISTRO_NAME},

         diskid_searchargs => {
                               file => '.disc2-i386',
                               key  => '1000086355.369516',
         },
         diskid_searchprog => \&linux_diskid_match_prog,
         diskid_target     => 'RedHat7.2-i386',
        },
        ];

    $::pkgdefs{distro_disks} = $dd_ref;
}

#--------------------------------------------------------------------------------

=head3	opensrc_prereqs - Open Source Prereqs to Install

        Notes:

=cut

#--------------------------------------------------------------------------------
{
    my $opr_ref;

    # defaults
    $opr_ref{$_server_}{$::csm_version} =
      ['tftp-hpa', 'syslinux', 'IBMJava2-JRE-1.4.1', 'conserver', 'fping'];
    $opr_ref{$_node_}{$::csm_version} = ['autoupdate'];

    # exceptions  - must follow the default assignments.
    $opr_ref{$_node_}{'1.2.0'} = [];

    # server and node exception
    if ($::ITDAGENT eq "true")
    {
        $opr_ref{$_server_}{$::csm_version} = [
                             @{$opr_ref{$_server_}{$::csm_version}}, 'ITDAgent',
                             'DirAgent',                             'RAIDLxAg',
                             'MPAAgent'
                             ];
        $opr_ref{$_node_}{$::csm_version} = [
                             @{$opr_ref{$_node_}{$::csm_version}}, 'ITDAgent',
                             'DirAgent',                             'RAIDLxAg',
                             'MPAAgent'
                             ];
    }

    $::pkgdefs{opensrc_prereqs} = $opr_ref{$::mgmt_type}{$::csm_version};
}

#--------------------------------------------------------------------------------

=head3	rsct_packages - RSCT Packages to Install

        Notes:

=cut

#--------------------------------------------------------------------------------
{
    my $rp_ref;

    # defaults
    $rp_ref = ['src', 'rsct.core.utils', 'rsct.core', 'rsct.basic'];

    # exceptions  - must follow the default assignments.
    # none

    $::pkgdefs{rsct_packages} = $rp_ref;
}

#--------------------------------------------------------------------------------

=head3	csm_packages - CSM Packages to Install

        Notes:

=cut

#--------------------------------------------------------------------------------
{
    my $cp_ref;

    # defaults

    $cp_ref{$_server_}{$::csm_version} =
      ['csm.core', 'csm.dsh', 'csm.server', 'csm.diagnostics', 'csm.gui.dcem'];
    $cp_ref{$_node_}{$::csm_version} =
      ['csm.core', 'csm.client', 'csm.diagnostics'];

    # exceptions  - must follow the default assignments.
    $cp_ref{$_node_}{'1.2.0'} = ['csm.core', 'csm.client'];

    $::pkgdefs{csm_packages} = $cp_ref{$::mgmt_type}{$::csm_version};
}

#--------------------------------------------------------------------------------

=head3	director_packages - Director Packages to Install

        Notes:

=cut

#--------------------------------------------------------------------------------
{
    my $dp_ref;

    # defaults
    $dp_ref{$_server_}{$::csm_version} =
      ['csm.director.agent', 'csm.director.server'];
    $dp_ref{$_node_}{$::csm_version} =
      ['csm.director.agent', 'csm.director.server'];

    # exceptions  - must follow the default assignments.
    $dp_ref{$_node_}{'1.2.0'} = [];
    $dp_ref{$_node_}{'1.3.0'} = [];

    $::pkgdefs{director_packages} = $dp_ref{$::mgmt_type}{$::csm_version};
}

#--------------------------------------------------------------------------------

=head3	rsct_unpackages - RSCT Packages to uninstall

        Notes:

=cut

#--------------------------------------------------------------------------------
{
    my $ru_ref;

    # defaults
    $ru_ref = ['src', 'rsct.core.utils', 'rsct.core'];

    # exceptions  - must follow the default assignments.
    # none

    $::pkgdefs{rsct_unpackages} = $ru_ref;
}

#--------------------------------------------------------------------------------

=head3	csm_unpackages - CSM Packages to uninstall	

        Notes:

=cut

#--------------------------------------------------------------------------------
{
    my $cup_ref;

    # defaults
    $cup_ref{$_server_}{$::csm_version} =
      ['csm.dsh', 'csm.server', 'csm.diagnostics', 'csm.gui.dcem'];
    $cup_ref{$_node_}{$::csm_version} =
      ['csm.core', 'csm.diagnostics', 'csm.client'];

    # exceptions  - must follow the default assignments.
    $cup_ref{$_node_}{'1.2.0'} = ['csm.core', 'csm.client'];

    $::pkgdefs{csm_unpackages} = $cup_ref{$::mgmt_type}{$::csm_version};
}

#--------------------------------------------------------------------------------

=head3	csm_uninstall_dirs - Directories to uninstall from the management server

        Notes:

=cut

#--------------------------------------------------------------------------------
{
    my $cud_ref;

    # defaults
    $cud_ref{$_server_}{$::csm_version} = ['/csminstall', '/cfmroot'];
    $cud_ref{$_node_}{$::csm_version}   = [];

    # exceptions  - must follow the default assignments.
    # none

    $::pkgdefs{csm_uninstall_dirs} = $cud_ref{$::mgmt_type}{$::csm_version};
}

#--------------------------------------------------------------------------------

=head3	csm_nouninstall_pkgs - Packages to NOT uninstall

        Notes:

=cut

#--------------------------------------------------------------------------------
{
    my $cnp_ref;

    # defaults
    $cnp_ref{$_server_}{$::csm_version} = ['csm.core'];
    $cnp_ref{$_node_}{$::csm_version}   = [];

    # exceptions  - must follow the default assignments.
    # none

    $::pkgdefs{csm_nouninstall_pkgs} = $cnp_ref{$::mgmt_type}{$::csm_version};
}

#--------------------------------------------------------------------------------

=head3	os_prereqs - Operating System pre-requisites

        Notes:

=cut

#--------------------------------------------------------------------------------
{
    my $op_ref;

    $op_ref{$_server_} = [
                          'perl-5*',           'nfs-utils-*',
                          'pdksh-*',           'dhcp-*',
                          'rdist-6*',          'tcl-8.3*',
                          'tk-8.3*',           'expect-5.32*',
                          'XFree86-libs-4.1*', 'freetype-2.0*',
                          ];
    $op_ref{$_node_} =
      ['perl-5*', 'nfs-utils-*', 'pdksh-*', 'rdist-6*', 'perl-libnet-1.07*',];

    $::pkgdefs{os_prereqs} = $op_ref{$::mgmt_type};
}

#--------------------------------------------------------------------------------

=head3	getmacs_Exec

        Notes:	non-eth0 support

=cut

#--------------------------------------------------------------------------------
{

    my $ge_ref = [
                  'usr/bin/grep', 'usr/sbin/ifconfig',
                  'usr/bin/sed',  'usr/bin/sleep',
                  'usr/bin/bash'
                  ];

    $::pkgdefs{getmacs_Exec} = $ge_ref;
}

#--------------------------------------------------------------------------------

=head3	getmacs_Lib

        Notes:	non-eth0 support

=cut

#--------------------------------------------------------------------------------
{
    my $gl_str = '/lib';

    $::pkgdefs{getmacs_Lib} = $gl_str;
}

#--------------------------------------------------------------------------------

=head3	getmacs_ReqLibs

        Notes:	non-eth0 support

=cut

#--------------------------------------------------------------------------------
{
    my $gr_ref = [
                  '/lib/ld-linux.so.2', '/lib/libc.so.6',
                  '/lib/libdl.so.2',    '/lib/libtermcap.so.2'
                  ];

    $::pkgdefs{getmacs_ReqLibs} = $gr_ref;
}

#--------------------------------------------------------------------------------

=head3	getmacs_DirStructure

        Notes:	non-eth0 support

=cut

#--------------------------------------------------------------------------------
{
    my $gd_ref = [
                  "bin",  "etc",      "linuxrc", "modules",
                  "proc", ".profile", "sbin",    "tmp",
                  "var"
                  ];

    $::pkgdefs{getmacs_DirStructure} = $gd_ref;
}

#--------------------------------------------------------------------------------

1;    # end
